extends Node2D

@export var place:Control

var _root:CanvasLayer
var _place_width:LineEdit
var _place_height:LineEdit
var _create_width:LineEdit
var _create_height:LineEdit
var _wait_create:Control
var _mouse_point:Label

func _ready():
	_root = $CanvasLayer
	_place_width = _root.get_node("Control/Rows/PlaceWidth") as LineEdit
	_place_height = _root.get_node("Control/Rows/PlaceHeight") as LineEdit
	_create_width = _root.get_node("Control/Rows/CreateWidth") as LineEdit
	_create_height = _root.get_node("Control/Rows/CreateHeight") as LineEdit
	_mouse_point = _root.get_node("Control/Rows/MousePoint") as Label
	set_process(false)
	
# 如果鼠标这时候点击右键代表取消构建, 直接 _wait_create 删除并置空
func _input(event:InputEvent):
	if _wait_create and event is InputEventMouseButton:
		if event.button_index == MOUSE_BUTTON_RIGHT:
			print_debug("取消建筑构建")
			for child in _wait_create.get_children():
				_wait_create.remove_child(child)
			_root.remove_child(_wait_create)
			_wait_create = null
			
		elif event.button_index == MOUSE_BUTTON_LEFT:
			# 左键点击在指定位置创建建筑
			_wait_create = null
			


func _process(delta):
	
	# 确认有准备创建任务
	if _wait_create and place:
		
		# 获取鼠标在屏幕的位置
		var pos:Vector2 = get_viewport().get_mouse_position()
		
		# 显示目前指针位置
		_mouse_point.text = "| 当前指针位置:(%d,%d)" % [ int(pos.x),int(pos.y) ]
		
		# 需要把鼠标视点的位置点转化成平面位置
		# 实际上就是把全局鼠标位置坐标系转化平面位置坐标系
		# 如果是3D项目还有射线检测处理把屏幕坐标系转化为建筑平面的局部坐标系再计算
		# ignore, 这里不需要处理太复杂, 默认采用屏幕 (0,0) 做平面起始点
		
		# 建筑跟随鼠标
		_wait_create.position = pos
		
		# 判断是否在平面中, 在平面显示绿色可用, 不在平面则直接红色不可用
		var child = _wait_create.get_child(0)
		if child is ColorRect:
			# 这里需要计算建筑位移换算出建筑宽高
			if in_square_2d(place.position,place.size - _wait_create.size,_wait_create.position,_wait_create.size):
				child.color = Color.GREEN
			else:
				child.color = Color.RED
	else:
		_wait_create = null
		set_process(false)


# 关键函数, 判断对比 active 坐标系是否和 place 坐标系重合
func in_square_2d(place_pos:Vector2,place_size:Vector2,active_pos:Vector2,active_size:Vector2)->bool:
	
	###  计算平面
	var place_min_x = int(place_pos.x) # 平面左上最小X起始位置: 0(以当前屏幕计算, 如果不是以原点就是其偏差值)
	var place_min_y = int(place_pos.y) # 平面左上最小Y起始位置: 0(同上)
	var place_max_x = place_min_x + int(place_size.x) - 1 # 计算出平台具体覆盖宽X范围, 内部已经含位置偏移量
	var place_max_y = place_min_y + int(place_size.y) - 1 # 计算出平台具体覆盖高Y范围, 同上
	
	### 计算建筑
	var build_min_x = int(active_pos.x) # 建筑最小X起始
	var build_min_y = int(active_pos.y) # 建筑最小Y起始
	var build_max_x = build_min_x + active_size.x - 1 # 计算出建筑覆盖的X范围
	var build_max_y = build_min_y + active_size.y - 1 # 计算出建筑覆盖的Y范围
	
	# 这里可以仔细思考为什么会有 -1 偏差?
	
	### 计算最小是否越界
	if build_min_x < place_min_x or build_max_y < place_min_y:
		return false
	
	
	### 求是否相交
	# 获取到了左上右下坐标相关参数
	var min_x = maxi(place_min_x,build_min_x) # 求出X起始
	var min_y = maxi(place_min_y,build_min_y) # 求出Y起始
	var max_x = mini(place_max_x,build_max_x) # 请求X终点
	var max_y = mini(place_max_y,build_max_y) # 请求Y终点
	# 计算相交与否
	if min_x > max_x or min_y > max_y:
		return false
	else:
		return true

# 创建构建平面
func _on_place_button_pressed():
	var w = float(_place_width.text)
	var h = float(_place_height.text)
	print_debug("place width: ",w)
	print_debug("place heigth: ",h)
	
	if place:
		place.set_size(Vector2(w,h))


# 创建指定宽高建筑
func _on_create_button_pressed():
	var w = float(_create_width.text)
	var h = float(_create_height.text)
	print_debug("create width: ",w)
	print_debug("create heigth: ",h)
	
	
	# 动态创建建筑对象
	var created:Control = Control.new()
	var bg:ColorRect = ColorRect.new()
	bg.color = Color.GREEN
	bg.set_size(Vector2(w,h))
	created.set_size(Vector2(w,h))
	created.add_child(bg)
	created.name = ("WaitCreateNode(%f,%f)" % [w,h])
	_root.add_child(created)
	
	# 确认之间是否生成过, 生成过节点需要删除
	if _wait_create:
		for child in _wait_create.get_children():
			_wait_create.remove_child(child)
		_root.remove_child(_wait_create)
		
	# 更新节点并且启动帧更新
	_wait_create = created
	set_process(true)
